/*---------------------------------------------------------------------------*/
/*                                                                           */
/* FILE:    cvidll.c                                                         */
/*                                                                           */
/* PURPOSE: This project demonstrates how to build a simple 32-bit DLL in    */
/*          LabWindows/CVI.  To build the DLL and import library, select     */
/*          "Create Dynamic-link Library" from the Project Window's Build    */
/*          menu.  When prompted, press "Export what?" specify "Include File */
/*          Symbols" in cvidll.h.  This will tell LabWindows/CVI to mark all */
/*          of the symbols found in the header file for export and include   */
/*          them in the generated import library mydll.lib.  Once generated, */
/*          you can add mydll.lib to the useit.prj project and successfully  */
/*          call the DLL functions.                                          */
/*                                                                           */
/*---------------------------------------------------------------------------*/


//Necessary compiler defines:
//     /DWIN32_LEAN_AND_MEAN /D_MSC_VER=0

/*---------------------------------------------------------------------------*/
/* Include files                                                             */
/*---------------------------------------------------------------------------*/
#include <cvirte.h>
#include "cvidll.h"
#include <userint.h>
#include <ansi_c.h>
#include <windows.h>  // DriverLINX uses definitions from this header file
#include "drvlinx.h"  // DriverLINX header provided on your system
#include "dlcodes.h"  // DriverLINX header provided on your system
#include <string.h>


HWND window;                      // Window handle needed for DriverLINX
HINSTANCE driverInstance;         // A Driver Instance needed to Open DriverLINX
DL_SERVICEREQUEST *pSR;           // A Service Request 
        
        

/*---------------------------------------------------------------------------*/
/* This is the DLL's main entry-point.  When the OS loads or unloads this    */
/* DLL, it will call this function with the apropriate event.                */ 
/*---------------------------------------------------------------------------*/
int __stdcall DllMain (HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
    switch (fdwReason)
        {
        case DLL_PROCESS_ATTACH:
            
            /* Respond to DLL loading by initializing the RTE */
            if (InitCVIRTE (hinstDLL, 0, 0) == 0) 
                return 0;
            break;
        case DLL_PROCESS_DETACH:
            
            /* Respond to DLL unloading by closing the RTE for its use */
            if (!CVIRTEHasBeenDetached ())
                CloseCVIRTE (); 
            break;
        }
    
    /* Return 1 to indicate successful initialization */
    return 1;
}

/*---------------------------------------------------------------------------*/
/* This exported function will be available to callers of our DLL.    */
/*---------------------------------------------------------------------------*/

int __stdcall OpenAndInit (char pDriverName[80],int Device)  
{
    window = GetDesktopWindow();   // DriverLINX messages will be sent to this window
    // for IRQ or DMA tasks, we'd want the real window so we could process messages
    
    // open the DriverLINX driver
    driverInstance=OpenDriverLINX(window,pDriverName); // use driver name as parameter
    
   pSR=(DL_SERVICEREQUEST*)malloc(sizeof(DL_SERVICEREQUEST)); //Allocate space for the Service Request
   memset(pSR,0,sizeof(DL_SERVICEREQUEST));   //Initialize the Service Request                         
   DL_SetServiceRequestSize(*pSR);   //Setup the Service Request for usage                           
   pSR->hWnd=window;                //Set the Widows handle property                                
   pSR->device=Device;             //Set the device property, in this case it is device 0          
   pSR->subsystem=DEVICE;   //We are commnicating with the DEVICE, not AI, AO, etc. 
   pSR->mode=OTHER;             //The mode is OTHER, not DMA or INTerrupt                       
   pSR->operation=INITIALIZE;   //The operation is to INITIALIZE the driver
   DriverLINX(pSR);                //Execute the Service Request                                                                                                                                    
   if(pSR->result!=NoErr)       //Check for errors                                              
      {                                                                                                   
        //pSR->operation=MESSAGEBOX;                                                                      
        //DriverLINX(pSR);  
        return -1;  // indicate an error has occured
      }    else
      {
         return 0;  // all is well
      }
    
}

/*---------------------------------------------------------------------------*/
/* This sample exported function will be available to callers of our DLL.    */
/*---------------------------------------------------------------------------*/

int __stdcall ReadDI (int channel)	   // return DI value
{
   	SelectDriverLINX(driverInstance);  // in case DLL used in combination with other DriverLINX drivers
	pSR->subsystem = DI;         	 // use the DI subsystem
    pSR->mode=POLLED;                    //The mode is POLLED I/O                                        
    pSR->timing.typeEvent=NULLEVENT;
    pSR->start.typeEvent=NULLEVENT;
    pSR->stop.typeEvent=NULLEVENT;
    pSR->channels.nChannels=1;           //The total number of channels is 1                             
    pSR->channels.chanGain[0].channel=channel; //which channel                                   
    pSR->status.typeStatus=IOVALUE;      //We are sending an I/O value                                   
    pSR->operation = START;                      //The operation is to START                                                                                                                                        
    DriverLINX(pSR);                                //Execute the Service Request                                                                                                                                      
    if(pSR->result!=NoErr)                       //Check for errors                                              
      {                                                                                                   
        //TODO:  determine which DriverLINX error and report various return codes                                                                      
        return -1;  // indicate an error has occured
      }  else
      {
         return  pSR->status.u.ioValue;           
      }
      
}


/*---------------------------------------------------------------------------*/
/* This sample exported function will be available to callers of our DLL.    */
/*---------------------------------------------------------------------------*/

void __stdcall CloseDriver (void)
{
	  SelectDriverLINX(driverInstance);  // in case DLL used in combination with other DriverLINX drivers
      free(pSR);                              //Free memory
      pSR = NULL;
      CloseDriverLINX(driverInstance);        //Close the Driver

}





